<?php

include_once 'db.php';

// Start the session
session_start();
$user_id = $_SESSION['user_id'] ?? null;

// Set Content-Type header to application/json for API responses
header('Content-Type: application/json');
// Retrieve the raw JSON input
$inputJSON = file_get_contents('php://input');
$inputData = json_decode($inputJSON, true); // Decode JSON to an associative array

// Ensure the required variables are provided in the JSON payload
if (isset($inputData['stockoutid']) && isset($inputData['qtyvaluetextbox'])) {
    $stockoutid = $inputData['stockoutid'];
    $qtyvaluetextbox = $inputData['qtyvaluetextbox'];


    // Step 1: Check if enough stock is available in the product table
    $checkStock = "SELECT qty FROM product WHERE Product_id='$stockoutid'";
    $resultStock = mysqli_query($conn, $checkStock);
    $rowStock = mysqli_fetch_assoc($resultStock);

    if (!$rowStock || $rowStock['qty'] < $qtyvaluetextbox) {
        echo json_encode(['status' => 'error', 'message' => 'Insufficient stock in Product table.']);
        exit;
    }

    // Step 2: Update the product table by reducing the quantity
    $sql = "UPDATE product SET qty = qty - $qtyvaluetextbox WHERE Product_id='$stockoutid'";
    $sqlexecute = mysqli_query($conn, $sql);

    if (!$sqlexecute) {
        echo json_encode(['status' => 'error', 'message' => 'Failed to update Product stock. MySQL Error: ' . mysqli_error($conn)]);
        exit;
    }

    // Step 3: Check if the product exists in the inventory table
    $checkInventory = "SELECT * FROM inventory WHERE Product_id='$stockoutid'";
    $inventoryResult = mysqli_query($conn, $checkInventory);

    if (mysqli_num_rows($inventoryResult) > 0) {
        // If the product exists in the inventory, reduce the quantity
        $rowInventory = mysqli_fetch_assoc($inventoryResult);

        if ($rowInventory['qty'] < $qtyvaluetextbox) {
            echo json_encode(['status' => 'error', 'message' => 'Insufficient stock in Inventory table.']);
            exit;
        }

        $updateInventory = "UPDATE inventory SET Qty = Qty - $qtyvaluetextbox, date_modified = NOW() WHERE Product_id='$stockoutid'";
        $updateExecute = mysqli_query($conn, $updateInventory);

        if (!$updateExecute) {
            echo json_encode(['status' => 'error', 'message' => 'Failed to update Inventory. MySQL Error: ' . mysqli_error($conn)]);
        } else {
            echo json_encode(['status' => 'success', 'message' => 'Inventory updated successfully.']);
        }
    } else {
        // If the product does not exist in the inventory, we can't reduce stock
        echo json_encode(['status' => 'error', 'message' => 'Product does not exist in Inventory.']);
    }
} else {
    // Missing parameters in the POST request
    echo json_encode(['status' => 'error', 'message' => 'Required parameters are missing.']);
}

?>
